/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.factories;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.Vector2;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import technology.rocketjump.undermount.entities.EntityAssetUpdater;
import technology.rocketjump.undermount.entities.behaviour.HumanoidBehaviour;
import technology.rocketjump.undermount.entities.components.ProfessionsComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.LocationComponent;
import technology.rocketjump.undermount.entities.model.physical.PhysicalEntityComponent;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HaulingComponent;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidEntityAttributes;
import technology.rocketjump.undermount.jobs.ProfessionDictionary;
import technology.rocketjump.undermount.jobs.model.Profession;
import technology.rocketjump.undermount.mapping.model.TiledMap;

@Singleton
public class HumanoidEntityFactory {
    private final MessageDispatcher messageDispatcher;
    private final EntityAssetUpdater entityAssetUpdater;
    private final ProfessionDictionary professionDictionary;

    @Inject
    public HumanoidEntityFactory(MessageDispatcher messageDispatcher, ProfessionDictionary professionDictionary, EntityAssetUpdater entityAssetUpdater) {
        this.messageDispatcher = messageDispatcher;
        this.professionDictionary = professionDictionary;
        this.entityAssetUpdater = entityAssetUpdater;
    }

    public Entity create(HumanoidEntityAttributes attributes, Vector2 worldPosition, Vector2 facing, TiledMap areaMap, Profession profession) {
        PhysicalEntityComponent physicalComponent = new PhysicalEntityComponent();
        physicalComponent.setAttributes(attributes);
        HumanoidBehaviour behaviourComponent = new HumanoidBehaviour();
        LocationComponent locationComponent = new LocationComponent();
        locationComponent.setWorldPosition(worldPosition, true);
        Entity entity = new Entity(EntityType.HUMANOID, physicalComponent, behaviourComponent, locationComponent, this.messageDispatcher, areaMap);
        entity.addComponent(new HaulingComponent());
        locationComponent.setFacing(facing);
        ProfessionsComponent professionsComponent = new ProfessionsComponent();
        if (profession == null) {
            profession = this.professionDictionary.getDefault();
        }
        professionsComponent.add(profession, 0.5f);
        entity.addComponent(professionsComponent);
        this.entityAssetUpdater.updateEntityAssets(entity);
        return entity;
    }
}

